<div class="col-12">
    <form action="{{ route('admin.appointments.save') }}" method="POST" enctype="multipart/form-data"
        class="p-3 bg-white">
        @csrf
        <div class="form-group row">
            <div class="col-12 col-lg-6 col-xl-4">
                <label class="col-form-label" for="patient">{{ __('admin/appointments.form.patients') }}</label>
                <select id="patients" name="patient" class="form-control selectpicker" data-live-search="true">
                    <option value="-1" disabled selected></option>
                    @foreach ($patients as $patient)
                        <option value="{{ $patient->id }}">{{ $patient->full_name }}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-12 col-lg-6 col-xl-4">
                <label class="col-form-label" for="patient">{{ __('admin/appointments.form.branch') }}</label>
                <select id="branches" name="branch" class="form-control selectpicker" data-live-search="true">
                    <option value="-1" disabled selected></option>
                    @foreach ($branches as $branch)
                        <option value="{{ $branch->id }}">{{ $branch->branch }}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-12 col-lg-6 col-xl-4">
                <label class="col-form-label" for="services">{{ __('admin/appointments.form.service') }}</label>
                <select id="services" name="service" class="form-control selectpicker" data-live-search="true">
                </select>
            </div>
        </div>
        <div id="sessions-table" class="form-group row mt-5">
            
        </div>
    </form>


    <script>
        $(document).ready(function() {

            $(document).on('change','#services', function() {

                let service = this.value;

                $.ajax({
                    type: "GET",
                    url: "{{ route('admin.appointments.get_users') }}" + '/' + service,
                    dataType: "json",
                    beforeSend: function() {
                        $('#loading-overlay').addClass('is-active');
                    },
                    error: function(XMLHttpRequest) {
                        console.log(XMLHttpRequest.responseText);
                        $('#loading-overlay').removeClass('is-active');
                        $('#users').attr('disabled');
                        
                    },
                    success: function(data) {
                        let html = '<option value="-1" disabled selected>-- Select --</option>';

                        $.each(data.users, function(index, value) {


                            html += '<option value="' + value.id + '">' + value
                                .first_name + ' ' + value.last_name + '</option>'
                        });

                        $('#users').html(html);

                        $('#users').removeAttr('disabled');
                    },
                    complete: function(msg) {
                        $('#loading-overlay').removeClass('is-active');
                    }
                });


            });


            $(document).on('change','#users', function() {

                let user = this.value;
                let service = $( "#services option:selected" ).attr('value');

                $.ajax({
                    type: "GET",
                    url: "{{ route('admin.appointments.get_calendar') }}" + '/0/' + service + '/' + user,
                    dataType: "html",
                    beforeSend: function() {
                        $('#loading-overlay').addClass('is-active');
                    },
                    error: function(XMLHttpRequest) {
                        alert('error');
                        $('#loading-overlay').removeClass('is-active'); 
                    },
                    success: function(data) {
                       $('#sessions-table').html(data);
                    },
                    complete: function(msg) {
                        $('#loading-overlay').removeClass('is-active');
                    }
                });
            });

        });
    </script>
</div>
